# The Best Magento 2 SEO Extension FREE

**Mageplaza SEO All-in-One for Magento 2** is a bundle of outstanding features that are auto-active when you install it from Mageplaza without any code modifications. It is also friendly with your store if you need to insert meta keywords and meta descriptions for your product. It will do perfectly for your better SEO.

[![Latest Stable Version](https://poser.pugx.org/mageplaza/magento-2-seo-extension/v/stable)](https://packagist.org/packages/mageplaza/magento-2-seo-extension)
[![Total Downloads](https://poser.pugx.org/mageplaza/magento-2-seo-extension/downloads)](https://packagist.org/packages/mageplaza/magento-2-seo-extension)

## Highlight Features for SEO Standard Edition
- Prevent Duplicate Content issue
- XML, HTML Sitemap
- Structured Data (Rich Snipet: Adding Rating, Reviews, Price, Stock status ...)
- Google, Bing, Pinterest ... verification
- Add Canonical URLs



## 1. SEO Documentation

- [Installation guide](https://www.mageplaza.com/install-magento-2-extension/)
- [User Guide](https://docs.mageplaza.com/seo-m2/index.html)
- [Download from our Live site](https://www.mageplaza.com/magento-2-seo-extension/)
- [Get Free Support](https://github.com/mageplaza/magento-2-seo/issues)
- Get premium support from Mageplaza: [Purchase Support package](https://www.mageplaza.com/magento-2-extension-support-package/)
- [Contribute on Github](https://github.com/mageplaza/magento-2-seo)
- [Releases](https://github.com/mageplaza/magento-2-seo/releases)
- [License](https://www.mageplaza.com/LICENSE.txt)



## 2. How to install Magento 2 SEO extension

### Install module via composer (recommend)

Run the following command in Magento 2 root folder:

With Social Proof (Recommend):
```
composer require mageplaza/magento-2-seo-extension mageplaza/module-sitemap avada/module-proofo
php bin/magento setup:upgrade
```

Without Social Proof:
```
composer require mageplaza/magento-2-seo-extension mageplaza/module-sitemap
php bin/magento setup:upgrade
```

### Install Package from copy-paste package

Download the latest version at [Mageplaza.com](https://www.mageplaza.com/magento-2-seo-extension/)
then follow [installation guide](https://www.mageplaza.com/install-magento-2-extension/)

## 3. SEO FAQs

#### Q: I got error: `Mageplaza_Core has been already defined`
A: Read solution: https://github.com/mageplaza/module-core/issues/3

#### Q: My site is down
A: Please follow this guide: https://www.mageplaza.com/blog/magento-site-down.html


## 4. Contribute to this SEO module

Feel free to **Fork** and contrinute to this module and create a pull request so we will merge your changes to `master` branch.


## 5. Magento 2 SEO Introduction

Improve your SEO for Magento 2 site. Use **Mageplaza SEO All in One** to automatically optimize your site for Search Engines.
**Mageplaza SEO extension** will automatically optimize and greatly improve the performance of your Magento-based store in Search Engines. Magento 2 is great SEO-ready out-of-the-box that is really good for SEO. However it still needs some craftiness to be improved in a few areas.

Mageplaza SEO module will support a list of new useful tools and settings that help you have own all the technical optimization with automatically optimizing and inserting the meta tags and link elements that Google or other Search Engines like so much:

### Stop Duplicating Content SEO

By automatically preventing the duplicate content problem, **Mageplaza SEO extension** will avoid your site from being affected badly to the search ranking or caused the traffic loss, and as a result, boost the SEO performance significantly.

![magento 2 seo duplicate content](https://i.imgur.com/BX2YeiW.jpg)


### Magento 2 Structured Data

**Mageplaza SEO All-in-One** will **add schema structured data to Magento 2 store** automatically without configuration to help Search engines display your web pages better and more attractive.

![Magento 2 structured data](https://i.imgur.com/Diw8ydK.png)

### SEO Metadata template rules (SEO Pro edition)

For the marketers, it’s critical to understand and use the metadata that helps to drive the customer from the search engines. With **Magento 2 SEO Pro edition**, it’s completely a huge advantage that you can set mass and dynamic metadata information for products, categories, pages, layered navigation.

![Magento 2 seo meta data](https://i.imgur.com/NdobHxN.jpg)


### Magento 2 Hreflang tag (SEO Ultimate edition)

You can easily to use the ‘Hreflang’ tags to tell the Search Engines which language you’re using in the specific page so when the visitors search in that language, your page will rank higher.

![Magento 2 Hreflang](https://i.imgur.com/PNu5Td4.jpg)

### SEO checklist (SEO Ultimate edition)

The smart list for a perfect performance! The SEO checklists can tell you what you haven’t done yet, what you should do or even warn you to make sure your SEO process is going the right way.

![Magento 2 seo checklist](https://i.imgur.com/0StlqWM.jpg)


### SEO HTML/XML Sitemaps (SEO Pro edition)

While the XML sitemap is specifically written for the search engines spiders, the HTML one is primarily for users. Hence, creating those 2 sitemaps will help your site to be easier to understand for both search engines and the users.

### LINK ALTERNATE TAG

Easily to Provides a link to an alternate version of the site by adding the rel=”alternate”.


### CONFIGURING ROBOTS METADATA TAG

Make your site content to be easier readable by the search engines by adding options: Follow/Nofollow/Noindex for Products, Categories, CMS Pages.

### LAYERED NAVIGATION SUPPORTED

A huge advantage when you have Megaplaza SEO extension is that it’s fully supported by [Layered Navigation](https://www.mageplaza.com/magento-2-layered-navigation-extension/) to make the SEO performance even better.


## Full Magento 2 SEO Features

- Automatically avoid duplicate content			
- Advanced Structured Data						
- Custom Meta tags: title, description, keywords			
- Hreflang tag	
- Social Shares
- Layered Navigation Support					
- URL Friendly			
- Link Alternate Tag			
- Opptimize canonical tag, rich snippet, alternate			
- Set Meta Robot Tags (Follow/Nofollow/Noindex) for Product, Category, CMS Page			
- Enchanced XML Sitemap		
- HTML Sitemap		
- Exclude CMS pages in HTML Sitemap		
- Include custom links in HTML Sitemap		
- Exclude out-of-stock in HTML, XML Sitemap		
- Metadata template rules for products, categories, cms pages		
- SEO Checklist	
- Page Analysis	
- Cross-links	
- Easy to install			
- Open source 100%			
- Easy to configure			
- User-friendly interface			
- 1-year Support			
- Lifetime updates			
- 30 days guarantee money back			
- Fully compatible with Mageplaza extensions			
- Supports multiple stores			
- Supports multiple languages			


### SEO Pricing

![Magento 2 seo pricing](https://i.imgur.com/m5ngLpE.png)



## 6. USER GUIDE

### Magento 2 SEO Basic Settings

Firstly, we will familiar with the module via the list of the configuration. Login as Admin account, go to the path `Mageplaza > SEO > Settings`.


#### General SEO Configuration


Open **General Configuration** section, you can see:

-   Add Nofollow meta in Search Result if you select "Yes" option
-   Add Nofollow meta in Product Gallery if you select "Yes" option
-   Setting Enable Sitelink Search Box to "Yes" means showing another
    search box that shows the more detailed search results on the
    destination site.

 In Stop words field, choose the language of the stop words to use. For example: if choose **en** (English), the stop words are *a the, of,
for, etc*.


#### SEO Duplicate Content Setting


Continue with the next session - **Duplicate Content**, there are some
configurations related to the duplicate content:

-   To manage your content better and restrict the duplication, please
    set "Yes" for Add Canonical URL Meta
-   In the Canonical points to https field, you can choose "Yes" or "No"
    option depending on whether you would prefer the https version of a
    page or not

![Configuration Duplicate Content for SEO](http://i.imgur.com/GiyZUa6.png)

#### Social Shares Setting


**Social Shares** provides the working fields that support for the
better SEO on the social channels. Now expand that section and do the
following:

-   It is possible to show **Open Graph** that is a short description of
    your website whenever visitors publish on the social medias like
    Facebook, Google+, Pinterest and other social networks.

    If disable the open graph on the social network, please choose "No"
    to turn it off in Add Open Graph meta tags field

-   You can also add Twitter Card Meta tags when the visitors share your
    website on Twitter
-   Enter Pinterest Confirmation Code to verify your website. Follow the
    instruction
    [here](https://help.pinterest.com/en/articles/confirm-your-website#meta_tag)
-   Enter Google+ Publisher Page if you need

![image](https://i.imgur.com/n0HsKaJ.png)


#### Magento 2 Structured Data Setting

Scroll down and expand the **Structured Data** section, you will:

-   Include Rich Snippet in the search results right after enabling the
    rich snippet in the configuration

    Rich Snippet may be review stars, an aggregate rating value, and
    vote count, etc.

-   Disable Product Structured Data by selecting "No" if your theme or
    module implements it's own product snippets.
-   Allow applying Organization Information that describes the results
    in detailed. Furthermore, you can custom that data via this
    [guide](https://mageplaza.freshdesk.com/support/solutions/articles/6000122360).

![Magento 2 Structured Data Setting](https://i.imgur.com/zqBgZjN.png)

#### Social Profiles Setting

Magento 2 SEO extension permits to show **Social Profiles** when your
website is searched on Google.

![Magento 2 Social Profiles Setting](https://i.imgur.com/N6IRXwm.png)

#### Business information

You can enable **Business Information** if choosing "Yes". Just enter
the information into the corresponding fields, then all of them will be
shown in the search result.

![Magento 2 SEO Business](https://i.imgur.com/xez4HkD.png)


#### Verifications

In the Verification field, you need to enter the verification code to
confirm the ownership of your site. Hence, you can use the Web services
such as Google Search Console, Bing Webmaster Tools, Pinterest and
Yandex Webmaster Tools.

![image](https://i.imgur.com/NRvUOEP.png)



**Mageplaza extensions on Magento Marketplace, Github**


☞ [Magento 2 One Step Checkout extension](https://marketplace.magento.com/mageplaza-magento-2-one-step-checkout-extension.html)

☞ [Magento 2 SEO Module](https://marketplace.magento.com/mageplaza-magento-2-seo-extension.html)

☞ [Magento 2 Blog extension](https://marketplace.magento.com/mageplaza-magento-2-blog-extension.html)

☞ [Magento 2 Layered Navigation extension](https://marketplace.magento.com/mageplaza-layered-navigation-m2.html)

☞ [Magento One Step Checkout](https://github.com/magento-2/one-step-checkout)

☞ [Magento 2 Blog on Github](https://github.com/mageplaza/magento-2-blog)

☞ [Magento 2 Social Login on Github](https://github.com/mageplaza/magento-2-social-login)

☞ [Magento 2 SEO on Github](https://github.com/mageplaza/magento-2-seo)

☞ [Magento 2 SMTP on Github](https://github.com/mageplaza/magento-2-smtp)

☞ [Magento 2 Product Slider on Github](https://github.com/mageplaza/magento-2-product-slider)



## SEO CHANGELOG 


### SEO v2.1.1
Released on  2018-06-05

Release notes: 

- Update copyright
#### SEO Ultimate
- Fixed error page when analysis enabled on the product which has no description.
- Fixed wrong hreflang URL when store using URL rewrite



### SEO v2.1.0
Released on  2018-04-23

Release notes: 

- Added General configuration.
- Added Product Structured Data configuration.
- Added Prevent Duplicated Content configuration in Product pages and Category pages
- Added Social Profiles.
- Added Business Information.
- Added On-page analysis.
- Added Sitelinks Searchbox.



### SEO v2.0.2
Released on  2017-12-12

Release notes: 

- Fix bug "cannot add structure data" on new product



### SEO v2.0.1
Released on  2017-11-13

Release notes: 

- Compatible with old version
- Compatible with Magento 2.2.x
- Fix error with structure data when created new product #54 



### SEO v2.0.0
Released on  2017-10-26

Release notes: 

Rebuilt Mageplaza SEO Standard edition. 
- Structured Data (Rich snippet  Schema) Star rating, Price, Inventory...
- Support Shop by brand in Structured Data.
- Webmaster Verifications Google Search Console, Bing, Yandex ...
- Fixed Duplicate Content (Basic)
- and more



### SEO v1.4.1
Released on  2017-06-12

Release notes: 

- Optimize Structured Data ld-json
- Optimize Social share Open graph (Google+ and Pinterest) and twitter card
- Fixed Breadcrumbs issue
- Fixed canonical link issue



### SEO v1.4.0
Released on  2017-05-23

Release notes: 

- Released Seo Crosslinks
- Fixed minor bugs



### SEO v1.3.1
Released on  2017-05-23

Release notes: 

- Fixed issue on bundle products
- Fixed Remove inject object in Search and Catalog block
- Optimize config object
- Optimize Search Nofollow



### SEO v1.3.0
Released on  2017-04-24

Release notes: 

**SEO Core , Sitemap**

* Exclude CMS pages in HTML Sitemap
+ Include custom links in HTML Sitemap
* Opt to exclude out-of-stock in HTML, XML Sitemap
* Optimize canonical tag, rich snippet, hrefLang, alternate

**Rule templates**

+ Compatible with Layered Navigation
+ Add Mageplaza_Blog posts meta data template
+ Optimize template rule products, categories, CMS pages.
+ Preview rule template




### SEO v1.2.2
Released on  2017-04-24

Release notes: 

- Edit composer.json to require mageplazamodule-core instead of mageplazacore-m2



### SEO v1.2.1
Released on  2017-04-09

Release notes: 

- Fix composer issue



### SEO v1.2.0
Released on  2017-04-09

Release notes: 

**Features**

+ Add Verification configuration
+ Add Stop words feature
+ Hreflang tags feature

**Bug fixes**

- Performance optimization
- Group SEO menu
- Optimize Configuration options




### SEO v1.1.4
Released on  2016-11-23

Release notes: 

- Fix Upgrade issue




### SEO v1.1.2
Released on  2016-11-22

Release notes: 

- Improve Robots meta tags categories, products, cms pages




### SEO v1.1.1
Released on  2016-10-20

Release notes: 

- add HTML Sitemap features




### SEO v1.1.0
Released on  2016-10-20

Release notes: 

#### Improvement
- Optimize code and performance
- Comment code

#### Features
- Add config Disable URL parameter in canonical URL

#### Bug fixing
- Fix bug canonical url




### SEO v1.0.2
Released on  2016-08-09

Release notes: 

- Compatible Magento 2.1
- Fix bug Dependency 
- Fix JSONLD broken tags
- Optimize Review rating value




### SEO v1.0.1
Released on  2016-07-20

Release notes: 

- Add composer and packagist.org



### SEO v1.0.0-beta
Released on  2016-04-23

Release notes: 

- Release first version


**Peoples also search:**
- Magento 2 seo
- magento 2 seo extension
- magento 2 seo extension free
- magento 2 seo module
- magento 2 seo github
- magento 2 advanced seo
- magento 2 seo suite
- magento 2 seo all in one
- magento 2 seo suite ultimate extension
- magento 2 seo suite ultimate
- seo suite ultimate for Magento 2
- magento 2 rich snippets
- magento 2 structured data
- magento 2 301 redirect extension
- magento 2 sitemap page
- magento 2 schema.org
- magento 2 schema markup
- magento 2 seo plugin 
- magento 2 schema
- magento 2 google rich snippets
- magento 2 rich snippets extension
- rich snippets magento 2

**Other free extension on Github**
- [Magento 2 Product slider](https://github.com/mageplaza/magento-2-product-slider)
- [Magento 2 GDPR](https://github.com/mageplaza/magento-2-gdpr)
- [Magento 2 popup extension](https://github.com/mageplaza/magento-2-better-popup)
- [Magento 2 Reports extension](https://github.com/mageplaza/magento-2-reports)
- [Magento 2 social login](https://github.com/mageplaza/magento-2-social-login)
- [Magento 2 blog](https://github.com/mageplaza/magento-2-blog)
- [Magento 2 Layered Navigation](https://github.com/mageplaza/magento-2-ajax-layered-navigation)
- [Magento 2 security extension](https://github.com/mageplaza/magento-2-security)

**Table of contents**
- [SEO Documentation](#1-seo-documentation)
- [How to install Magento 2 SEO extension](#2-how-to-install-magento-2-seo-extension)
  - [Install module via composer (recommend)](#install-module-via-composer-recommend)
  - [Install Package from copy-paste package](#install-package-from-copy-paste-package)
- [SEO FAQs](#3-seo-faqs)
- [Contribute to this SEO module](#4-contribute-to-this-seo-module)
- [Magento 2 SEO Introduction](#5-magento-2-seo-introduction)
  - [Stop Duplicating Content SEO](#stop-duplicating-content-seo)
  - [Magento 2 Structured Data](#magento-2-structured-data)
  - [SEO Metadata template rules (SEO Pro edition)](#seo-metadata-template-rules-seo-pro-edition)
  - [Magento 2 Hreflang tag (SEO Ultimate edition)](#magento-2-hreflang-tag-seo-ultimate-edition)
  - [SEO checklist (SEO Ultimate edition)](#seo-checklist-seo-ultimate-edition)
  - [Breadcrumbs](#breadcrumbs)
  - [SEO HTML/XML Sitemaps (SEO Pro edition)](#seo-htmlxml-sitemaps-seo-pro-edition)
  - [LINK ALTERNATE TAG](#link-alternate-tag)
  - [CONFIGURING ROBOTS METADATA TAG](#configuring-robots-metadata-tag)
  - [LAYERED NAVIGATION SUPPORTED](#layered-navigation-supported)
- [Full Magento 2 SEO Features](#full-magento-2-seo-features)
- [SEO Pricing](#seo-pricing)
- [USER GUIDE](#6-user-guide)
  - [Magento 2 SEO Basic Settings](#magento-2-seo-basic-settings)
- [SEO CHANGELOG](#seo-changelog)
