# Magento 2 Blog extension FREE

**Magento 2 Blog by Mageplaza** is integrated right into the Magento backend so you can manage your blog and your e-commerce store all in the one place. It is the perfect marketing tool for your bussiness that not only provides update information to your existing customers but also drive more visitors to your online store.

[![Codacy Badge](https://api.codacy.com/project/badge/Grade/7f52db083c5f47648e26d92060d75b73)](https://app.codacy.com/app/mageplaza/magento-2-blog?utm_source=github.com&utm_medium=referral&utm_content=mageplaza/magento-2-blog&utm_campaign=Badge_Grade_Dashboard)
[![Latest Stable Version](https://poser.pugx.org/mageplaza/magento-2-blog-extension/v/stable)](https://packagist.org/packages/mageplaza/magento-2-blog-extension)
[![Total Downloads](https://poser.pugx.org/mageplaza/magento-2-blog-extension/downloads)](https://packagist.org/packages/mageplaza/magento-2-blog-extension)


## 1. Documentation

- [Installation guide](https://www.mageplaza.com/install-magento-2-extension/)
- [User guide](https://docs.mageplaza.com/blog-m2/index.html)
- [Download from our Live site](https://www.mageplaza.com/magento-2-blog-extension/)
- Mageplaza Blog has been verified on [Magento Marketplace](https://marketplace.magento.com/mageplaza-magento-2-blog-extension.html)
- [Get Free Support](https://github.com/mageplaza/magento-2-blog-extension/issues)
- Get premium support from Mageplaza: [Purchase Support package](https://www.mageplaza.com/magento-2-extension-support-package/)
- [Contribute on Github](https://github.com/mageplaza/magento-2-blog/)
- [Releases](https://github.com/mageplaza/magento-2-blog/releases)
- [License](https://www.mageplaza.com/LICENSE.txt)

## 2. FAQs

#### Q: I got error: `Mageplaza_Core has been already defined`
A: Read solution: https://github.com/mageplaza/module-core/issues/3


## 3. How to install


## ✓ Install via composer (recommend)
Run the following command in Magento 2 root folder:

With GraphQL (Support PWA):

```
composer require mageplaza/magento-2-blog-extension mageplaza/module-blog-graphql
php bin/magento setup:upgrade
php bin/magento setup:static-content:deploy
```

Without GraphQL:

```
composer require mageplaza/magento-2-blog-extension
php bin/magento setup:upgrade
php bin/magento setup:static-content:deploy
```


### ✓ Install Magento 2 Blog GraphQL module only

```
composer require mageplaza/module-blog-graphql
php bin/magento setup:upgrade
php bin/magento setup:static-content:deploy
```

### ✓ Install ready-to-paste package

- Download the latest version at [Mageplaza Blog for Magento 2](https://www.mageplaza.com/magento-2-blog-extension/)
-  [Installation guide](https://www.mageplaza.com/install-magento-2-extension/)



## 4. Contribute to this module

Feel free to **Fork** and contrinute to this module and create a pull request so we will merge your changes to `master` branch.

Thanks [the contributors](https://github.com/mageplaza/magento-2-blog/graphs/contributors)

--------





## 6. Blog benefits

Magento 2 blog extension can give you a greate opportunity to communicate with your potential and existing customers. Blog posts can help you to create a 2-way communication platform to publish new information such as news, promotions, comming products. Read more benefits of Blog.

![Magento 2 blog extension by Mageplaza](https://www.mageplaza.com/assets/img/extensions-images/magento-2-blog/mobile-mockup.jpg)

### Drive more traffics
“Raise your hand if you need more targeted visitors. Sure, me too.”

Think of total number of pages you can find on your online store. Maybe not a ton, right? And think of how frequently you update those pages. Maybe not that usually, right? Well, running a blog helps resolve both of those problems.

Writing a blog helps as well you get discovered via social networks. Any time you write a blog post, you are building content that many people can share on social networking sites such as Twitter, LinkedIn, Facebook, Pinterest – which will help expose your web business to a new one audience that will not know you yet.

### It may help convert that traffic into leads.
Similar to every blog post you write is yet another indexed page, each post is really a new chance to generate new leads. The way in which this works is absolutely simple: Just put in a lead-generating call-to-action to each blog post.

### Boost Search Engine Optimization Ranking
Search Engines like Google loves fresh content. What better method to deliver frequent content compared to blog posts. By writing blog consistently, you provide Google and other search engines new content to index and you also create chances to plug in those all-important keywords to boost your visibility on search engine results pages (SERPS).

### Build relationships with your customers
Writing a blog enables you to interact with your website visitors. You can accomplish this by asking your visitors questions at the conclusion of your posts to obtain the conversation going or simply by allowing comments and feedback. By reviewing and answering readers’ comments, you may create a rapport together with your audience, build trust, and gain valuable insight into what your visitors are seeking.

## Magento 2 Blog full feature list

- Responsive design
- SEO friendly
- Post attributes
- Multiselect tags
- Numerous Comment engine: Magento Built-in comments, Facebook Comment, Disqus Comment.
- RSS Optimization
- WYSIWYG editor in admin
- Blog breadcrumbs
- Import from AW M1 Blog, Magefan Blog, Wordpress
- Integrate Magento Sitemap or Blog sitemap
- Multistores support


## Blog features for Magento 2
A better blog for your e-commerce store without adding any 3rd-party framework. Better blog extension allows you manage categories, posts, comments on Magento 2 back-end. The system will update you when there is a new comment submit. This is a great solution for building relevant SEO-friendly text links, and serves as assistance in building sales strategy.

### Responsive design
Mobile-friendly design will make allow you customers to read your blog posts with maximum comfort on tablets and smartphones. Using the off-canvas menu, they will be able to see widgets and interact with the blog search. Tested on Madison, Ultimo, Porto theme.

### Flexible display posts
It is very easy to add recent posts, post in specific category in homepage. Your customers also see recent posts in sidebar.

### SEO friendly
Properly optimized blog can get your site higher in search results and lead more potential customers. Better Blog allows you to create meta information not only for posts, but also for categories and tags.

### Post attributes
You can create unlimited attributes for post. It is extremely customized your blog by adding as many post attributes as you want to. It displays right in Post Edit and Frontend. No code modification required.

### Comments
Better Blog supports 3 types of comments: built-in comment, Disqus comment (coming soon), and Facebook comment (coming soon). You can switch comment solution in configuration.

### Sharing posts
Better blog is integrated with Addthis, that why your customers can share posts via about hundred social networks such as Facebook, Google+, Twitter, Instagram, Pinterest, Tumblr, Delicious, Digg , StubmleUpon, Linkedin, Reddit or email ….

### RSS Optimization
Full RSS integration into Magento 2. The blog RSS feed appears right next to the standard product and Magento 2 RSS feeds, allowing users that are familiar with your website to easily find all the blog RSS feeds easily and simply.

### Importer (NEW)

Import Blog Posts, Categories, Tags from [Wordpress](https://wordpress.org/), AW M1 Blog, Magefan M2 Blog


---------

## 7. USER GUIDE

### General Configuration


* Login to Magento Admin, `Better Blog > Settings`.

* Open **General** section, 

  * Enable the module when choosing “Yes” in the required field.
  
  * Set name for the new blog 
  
  * Enter the `URL Prefix` and `URL Suffix`. If leave empty for no suffix, use the default configuration (html)
  
  * To make the blog link visible on the top/ footer links on your site, set `Show Blog Link in Top/ Footer Links` to "Yes".
  
  * To show the sidebar on the storefront, select "Yes" in the `Show Sidebar Right/ Left` field.

![blog configuration](https://i.imgur.com/JWBqTOU.png)

* Open **Sidebar** section,

  * Enter `Number of recent posts` that display on the sidebar.
  
  * Enter `Number of most view posts` that display on the sidebar.

![config sidebar](http://i.imgur.com/FNR97UP.png)

* Open **Comments** section,

  * Set `Number of recent posts` to one of the following options:
  
    * Disqus Comment
    * Facebook Comment 
    * Disable Completely

![configure comment](http://i.imgur.com/v40bKQ1.png)

* Open **SEO** section, you can configure the meta that is useful for your better SEO

  * Set `Meta title for posts list page` 
  * Set `Meta description for posts list page`
  * Set `Meta keywords for posts list page`

![configure SEO](https://i.imgur.com/FAx534w.png)

* Open **Social** section,

  * Enable social buttons on the blog page
  * In the `Pubid` field, insert ID for Share buttons that get from https://addthis.com.
  
  In Social share session, we use Addthis.com to add more than 200 share buttons, and display only 4 most popular share buttons. You can custom these buttons by add your own Addthis Pub-id

![social buttons](https://i.imgur.com/QIs3FXz.png)

* Click on `Save Config` when complete.

### How to Create a New Post

* Step 1: Complete the post information
* Step 2: Assign to Topic
* Step 3: Assign to Categorie
* Step 4: Assign Tags to the post
  
#### Step 1: Complete the post information


* To display the new post, choose "Yes" in the `Enabled` field
* Login to Magento Admin, `Better Blog > Posts`
* On the upper-right corner, tap `Add New Posts` button
* Set `Name` for the new post
* Enter `Short Description` if you need
* Use WYSIWYG Mode to insert the post content that allows showing right as in the storefront.
  
  If you want to show the content under code, tap `Show/ Hide Editor` button.

* Upload image from your brower in the **Image** option.
* Enter the `URL Key` that the visitor can access the blog post
* To allow the readers leave comments on your post, choose "Yes" in the `Allow Comment` field.

* Complete `Meta Title`, `Meta Description`,and `Meta Keywords` for your better SEO.
* Set `Meta Robots` to one of the following opitons:

  * Index, Follow
  * NoIndex, NoFollow
  * NoIndex, Follow
  * Index, NoFollow


* Tap `Save and Continue Edit`

#### Step 2: Assign the post to Topic


* You can do it when you create a new post in the **Topics** tab, or go to **Posts** tab
* In the list of the available posts, mark the checkbox that is next to the posts you want to assign


* Tap `Save and Continue Edit`

#### Step 3: Assign to Categories


* You can do it when you create a new post in the **Categories** tab, or go to **Posts** tab
* In the list of the available posts, mark the checkbox that is next to the posts you want to assign


* Tap `Save and Continue Edit`

#### Step 4: Assign Tags to the post


* You can do it when you create a new post in the **Tags** tab, or go to **Posts** tab
* In the list of the available posts, mark the checkbox that is next to the posts you want to assign


* Tap `Save and Continue Edit`, then hit `Save Post` to finish. 

#### How to create a new Tag


* Login to Magento Admin, `Better Blog > Categories`
* To active the new tag, set `Enabled` to "Yes"
* Set `Name` for the new tag
* Use WYSIWYG Mode to enter the description of the tag
* Enter the `URL Key` that the visitor can access the tag


* If need, you can assign the new tag to specific post.
* Click on `Save Tag` when complete.


#### How to Create a new Topic


* Login to Magento Admin, `Better Blog > Topics`
* To active the new topic, set `Enabled` to "Yes"
* Set `Name` for the new topic
* Use WYSIWYG Mode to enter the description of the topic
* Enter the `URL Key` that the visitor can access the topic
* Complete `Meta Title`, `Meta Description`,and `Meta Keywords` for your better SEO.
* Set `Meta Robots` to one of the following opitons:

  * Index, Follow
  * NoIndex, NoFollow
  * NoIndex, Follow
  * Index, NoFollow


* If need, you can assign the new topic to specific post.
* Click on `Save Topic` when complete.

#### How to Create a new category


* Login to Magento Admin, `Better Blog > Categories`
* To active the new category, set `Enabled` to "Yes"
* Set `Name` for the new category
* Use WYSIWYG Mode to enter the description of the category
* Enter the `URL Key` that the visitor can access the category
* Complete `Meta Title`, `Meta Description`,and `Meta Keywords` for your better SEO.
* Set `Meta Robots` to one of the following opitons:

  * Index, Follow
  * NoIndex, NoFollow
  * NoIndex, Follow
  * Index, NoFollow


* If need, you can assign the new category to specific post.
* Click on `Save Category` when complete.



### How to add custom CMS Static Block in Blog Post



In this guide, we will show you how to add a custom content in Blog post such as: Call to action, promoted banner ...

There are few hidden tricks in Mageplza Blog for Magento 2. Here are hidden CMS Static Block:

- `mageplaza_blog_view_under_content` : Under Content section
- `mageplaza_blog_view_above_comment` : Above Comment section
- `mageplaza_blog_sidebar_above_popular_widget` : Above Popular/Recent posts widgets
- `mageplaza_blog_sidebar_above_categories_widget` : Above Categories widgets
- `mageplaza_blog_sidebar_above_tags_widget` : Above Tags widgets
- `mageplaza_blog_sidebar_under_tags_widget` : Under Tags wigets


See this:

![blog magento 2](https://i.imgur.com/EpVJPXR.jpg)




#### How to create CMS static block in Magento 2


From Admin panel > Content > Blocks > Add New Block


Then fill the content of block such as Name, idenity, content ...


then click on `Save and continue`



--------------


## 8. BLOG CHANGELOG 

Learn more https://www.mageplaza.com/releases/blog/





## Mageplaza extensions on Magento Marketplace, Github


☞ [Magento 2 One Step Checkout extension](https://marketplace.magento.com/mageplaza-magento-2-one-step-checkout-extension.html)

☞ [Magento 2 SEO Module](https://marketplace.magento.com/mageplaza-magento-2-seo-extension.html)

☞ [Magento 2 Blog extension](https://marketplace.magento.com/mageplaza-magento-2-blog-extension.html)

☞ [Magento 2 Layered Navigation extension](https://marketplace.magento.com/mageplaza-layered-navigation-m2.html)

☞ [Magento One Step Checkout](https://github.com/magento-2/one-step-checkout)


☞ [Magento 2 Social Login on Github](https://github.com/mageplaza/magento-2-social-login)

☞ [Magento 2 SEO on Github](https://github.com/mageplaza/magento-2-seo)

☞ [Magento 2 SMTP on Github](https://github.com/mageplaza/magento-2-smtp)

☞ [Magento 2 Product Slider on Github](https://github.com/mageplaza/magento-2-product-slider)

☞ [Magento 2 Banner on Github](https://github.com/mageplaza/magento-2-banner-slider)


