/*!
  Copyright 2013 Lovell Fuller and others.
  SPDX-License-Identifier: Apache-2.0
*/

const { describe, it } = require('node:test');
const assert = require('node:assert');

const sharp = require('../../');
const fixtures = require('../fixtures');

describe('Timeout', () => {
  it('Will timeout after 1s when performing slow blur operation', () => assert.rejects(
    () => sharp(fixtures.inputJpg)
      .blur(200)
      .timeout({ seconds: 1 })
      .toBuffer(),
    /timeout: [0-9]+% complete/
  ));

  it('invalid object', () => assert.throws(
    () => sharp().timeout('fail'),
    /Expected object for options but received fail of type string/
  ));

  it('invalid seconds', () => assert.throws(
    () => sharp().timeout({ seconds: 'fail' }),
    /Expected integer between 0 and 3600 for seconds but received fail of type string/
  ));
});
