<?php
/**
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade Smile ElasticSuite to newer versions in the future.
 *
 * @category  Smile
 * @package   Smile\ElasticsuiteCatalog
 * @author    Richard BAYET <richard.bayet@smile.fr>
 * @copyright 2025 Smile
 * @license   Open Software License ("OSL") v. 3.0
 */

namespace Smile\ElasticsuiteCatalog\Model\ResourceModel\Category\Indexer\Fulltext\Datasource;

use Smile\ElasticsuiteCatalog\Model\ResourceModel\Eav\Indexer\Indexer;

/**
 * Categories url rewrite datasource resource model.
 * Loads the URL rewrites from database.
 *
 * @category Smile
 * @package  Smile\ElasticsuiteCatalog
 */
class UrlRewriteData extends Indexer
{
    /**
     * Fetch url rewrites for category ids.
     *
     * @param int   $storeId     Store ID.
     * @param array $categoryIds The category ids
     *
     * @return array
     */
    public function loadUrlRewrites($storeId, $categoryIds)
    {
        $select = $this->getConnection()->select()
            ->from(['ur' => $this->getTable($this->getTable('url_rewrite'))])
            ->where('ur.store_id = ?', $storeId)
            ->where('ur.entity_type = ?', 'category')
            ->where('metadata is null')
            ->where('redirect_type = 0')
            ->where('ur.entity_id IN(?)', $categoryIds)
            ->order('ur.entity_id ASC')
            ->order('ur.is_autogenerated DESC');

        return $this->getConnection()->fetchAll($select);
    }
}
